package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApiDestinationProps {

  def apply(
    endpoint: String,
    connection: software.amazon.awscdk.services.events.IConnection,
    apiDestinationName: Option[String] = None,
    description: Option[String] = None,
    rateLimitPerSecond: Option[Number] = None,
    httpMethod: Option[software.amazon.awscdk.services.events.HttpMethod] = None
  ): software.amazon.awscdk.services.events.ApiDestinationProps =
    (new software.amazon.awscdk.services.events.ApiDestinationProps.Builder)
      .endpoint(endpoint)
      .connection(connection)
      .apiDestinationName(apiDestinationName.orNull)
      .description(description.orNull)
      .rateLimitPerSecond(rateLimitPerSecond.orNull)
      .httpMethod(httpMethod.orNull)
      .build()
}
