package io.burkard.cdk.services.emr

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClusterProps {

  def apply(
    name: String,
    jobFlowRole: String,
    serviceRole: String,
    instances: software.amazon.awscdk.services.emr.CfnCluster.JobFlowInstancesConfigProperty,
    kerberosAttributes: Option[software.amazon.awscdk.services.emr.CfnCluster.KerberosAttributesProperty] = None,
    applications: Option[List[_]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    bootstrapActions: Option[List[_]] = None,
    customAmiId: Option[String] = None,
    visibleToAllUsers: Option[Boolean] = None,
    logEncryptionKmsKeyId: Option[String] = None,
    managedScalingPolicy: Option[software.amazon.awscdk.services.emr.CfnCluster.ManagedScalingPolicyProperty] = None,
    scaleDownBehavior: Option[String] = None,
    securityConfiguration: Option[String] = None,
    logUri: Option[String] = None,
    autoTerminationPolicy: Option[software.amazon.awscdk.services.emr.CfnCluster.AutoTerminationPolicyProperty] = None,
    autoScalingRole: Option[String] = None,
    stepConcurrencyLevel: Option[Number] = None,
    additionalInfo: Option[AnyRef] = None,
    steps: Option[List[_]] = None,
    configurations: Option[List[_]] = None,
    releaseLabel: Option[String] = None,
    ebsRootVolumeSize: Option[Number] = None
  ): software.amazon.awscdk.services.emr.CfnClusterProps =
    (new software.amazon.awscdk.services.emr.CfnClusterProps.Builder)
      .name(name)
      .jobFlowRole(jobFlowRole)
      .serviceRole(serviceRole)
      .instances(instances)
      .kerberosAttributes(kerberosAttributes.orNull)
      .applications(applications.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .bootstrapActions(bootstrapActions.map(_.asJava).orNull)
      .customAmiId(customAmiId.orNull)
      .visibleToAllUsers(visibleToAllUsers.map(Boolean.box).orNull)
      .logEncryptionKmsKeyId(logEncryptionKmsKeyId.orNull)
      .managedScalingPolicy(managedScalingPolicy.orNull)
      .scaleDownBehavior(scaleDownBehavior.orNull)
      .securityConfiguration(securityConfiguration.orNull)
      .logUri(logUri.orNull)
      .autoTerminationPolicy(autoTerminationPolicy.orNull)
      .autoScalingRole(autoScalingRole.orNull)
      .stepConcurrencyLevel(stepConcurrencyLevel.orNull)
      .additionalInfo(additionalInfo.orNull)
      .steps(steps.map(_.asJava).orNull)
      .configurations(configurations.map(_.asJava).orNull)
      .releaseLabel(releaseLabel.orNull)
      .ebsRootVolumeSize(ebsRootVolumeSize.orNull)
      .build()
}
