package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CognitoOptions {

  def apply(
    identityPoolId: String,
    userPoolId: String,
    role: software.amazon.awscdk.services.iam.IRole
  ): software.amazon.awscdk.services.elasticsearch.CognitoOptions =
    (new software.amazon.awscdk.services.elasticsearch.CognitoOptions.Builder)
      .identityPoolId(identityPoolId)
      .userPoolId(userPoolId)
      .role(role)
      .build()
}
