package io.burkard.cdk.services.elasticloadbalancingv2

sealed abstract class SslPolicy(val underlying: software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy)
  extends Product
    with Serializable

object SslPolicy {
  implicit def toAws(value: SslPolicy): software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy =
    Option(value).map(_.underlying).orNull

  case object RecommendedTls
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.RECOMMENDED_TLS)

  case object Recommended
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.RECOMMENDED)

  case object Tls13Res
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_RES)

  case object Tls13Ext1
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_EXT1)

  case object Tls13Ext2
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_EXT2)

  case object Tls1310
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_10)

  case object Tls1311
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_11)

  case object Tls1313
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS13_13)

  case object ForwardSecrecyTls12ResGcm
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.FORWARD_SECRECY_TLS12_RES_GCM)

  case object ForwardSecrecyTls12Res
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.FORWARD_SECRECY_TLS12_RES)

  case object ForwardSecrecyTls12
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.FORWARD_SECRECY_TLS12)

  case object ForwardSecrecyTls11
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.FORWARD_SECRECY_TLS11)

  case object ForwardSecrecy
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.FORWARD_SECRECY)

  case object Tls12
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS12)

  case object Tls12Ext
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS12_EXT)

  case object Tls11
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.TLS11)

  case object Legacy
    extends SslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.LEGACY)
}
