package io.burkard.cdk.services.elasticloadbalancingv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkTargetGroupProps {

  def apply(
    port: Number,
    healthCheck: Option[software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck] = None,
    preserveClientIp: Option[Boolean] = None,
    targets: Option[List[_ <: software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget]] = None,
    deregistrationDelay: Option[software.amazon.awscdk.Duration] = None,
    proxyProtocolV2: Option[Boolean] = None,
    targetGroupName: Option[String] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    targetType: Option[software.amazon.awscdk.services.elasticloadbalancingv2.TargetType] = None,
    protocol: Option[software.amazon.awscdk.services.elasticloadbalancingv2.Protocol] = None,
    connectionTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps.Builder)
      .port(port)
      .healthCheck(healthCheck.orNull)
      .preserveClientIp(preserveClientIp.map(Boolean.box).orNull)
      .targets(targets.map(_.asJava).orNull)
      .deregistrationDelay(deregistrationDelay.orNull)
      .proxyProtocolV2(proxyProtocolV2.map(Boolean.box).orNull)
      .targetGroupName(targetGroupName.orNull)
      .vpc(vpc.orNull)
      .targetType(targetType.orNull)
      .protocol(protocol.orNull)
      .connectionTermination(connectionTermination.map(Boolean.box).orNull)
      .build()
}
