package io.burkard.cdk.services.elasticloadbalancing.cfnLoadBalancer

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessLoggingPolicyProperty {

  def apply(
    enabled: Boolean,
    s3BucketName: String,
    emitInterval: Option[Number] = None,
    s3BucketPrefix: Option[String] = None
  ): software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty =
    (new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty.Builder)
      .enabled(enabled)
      .s3BucketName(s3BucketName)
      .emitInterval(emitInterval.orNull)
      .s3BucketPrefix(s3BucketPrefix.orNull)
      .build()
}
