package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SsmParameterImageOptions {

  def apply(
    os: Option[software.amazon.awscdk.services.ec2.OperatingSystemType] = None,
    userData: Option[software.amazon.awscdk.services.ec2.UserData] = None,
    cachedInContext: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.SsmParameterImageOptions =
    (new software.amazon.awscdk.services.ec2.SsmParameterImageOptions.Builder)
      .os(os.orNull)
      .userData(userData.orNull)
      .cachedInContext(cachedInContext.map(Boolean.box).orNull)
      .build()
}
