package io.burkard.cdk.services.ec2

sealed abstract class FlowLogFileFormat(val underlying: software.amazon.awscdk.services.ec2.FlowLogFileFormat)
  extends Product
    with Serializable

object FlowLogFileFormat {
  implicit def toAws(value: FlowLogFileFormat): software.amazon.awscdk.services.ec2.FlowLogFileFormat =
    Option(value).map(_.underlying).orNull

  case object PlainText
    extends FlowLogFileFormat(software.amazon.awscdk.services.ec2.FlowLogFileFormat.PLAIN_TEXT)

  case object Parquet
    extends FlowLogFileFormat(software.amazon.awscdk.services.ec2.FlowLogFileFormat.PARQUET)
}
