package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkInsightsAccessScope {

  def apply(
    internalResourceId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    matchPaths: Option[List[_]] = None,
    excludePaths: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope =
    software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.Builder
      .create(stackCtx, internalResourceId)
      .tags(tags.map(_.asJava).orNull)
      .matchPaths(matchPaths.map(_.asJava).orNull)
      .excludePaths(excludePaths.map(_.asJava).orNull)
      .build()
}
