package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHostProps {

  def apply(
    availabilityZone: String,
    instanceType: Option[String] = None,
    hostRecovery: Option[String] = None,
    outpostArn: Option[String] = None,
    autoPlacement: Option[String] = None,
    instanceFamily: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnHostProps =
    (new software.amazon.awscdk.services.ec2.CfnHostProps.Builder)
      .availabilityZone(availabilityZone)
      .instanceType(instanceType.orNull)
      .hostRecovery(hostRecovery.orNull)
      .outpostArn(outpostArn.orNull)
      .autoPlacement(autoPlacement.orNull)
      .instanceFamily(instanceFamily.orNull)
      .build()
}
