package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHost {

  def apply(
    internalResourceId: String,
    availabilityZone: String,
    instanceType: Option[String] = None,
    hostRecovery: Option[String] = None,
    outpostArn: Option[String] = None,
    autoPlacement: Option[String] = None,
    instanceFamily: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnHost =
    software.amazon.awscdk.services.ec2.CfnHost.Builder
      .create(stackCtx, internalResourceId)
      .availabilityZone(availabilityZone)
      .instanceType(instanceType.orNull)
      .hostRecovery(hostRecovery.orNull)
      .outpostArn(outpostArn.orNull)
      .autoPlacement(autoPlacement.orNull)
      .instanceFamily(instanceFamily.orNull)
      .build()
}
