package io.burkard.cdk.services.dynamodb

sealed abstract class TableClass(val underlying: software.amazon.awscdk.services.dynamodb.TableClass)
  extends Product
    with Serializable

object TableClass {
  implicit def toAws(value: TableClass): software.amazon.awscdk.services.dynamodb.TableClass =
    Option(value).map(_.underlying).orNull

  case object Standard
    extends TableClass(software.amazon.awscdk.services.dynamodb.TableClass.STANDARD)

  case object StandardInfrequentAccess
    extends TableClass(software.amazon.awscdk.services.dynamodb.TableClass.STANDARD_INFREQUENT_ACCESS)
}
