package io.burkard.cdk.services.dms.cfnEndpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MicrosoftSqlServerSettingsProperty {

  def apply(
    safeguardPolicy: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None,
    readBackupOnly: Option[Boolean] = None,
    querySingleAlwaysOnNode: Option[Boolean] = None,
    useThirdPartyBackupDevice: Option[Boolean] = None,
    controlTablesFileGroup: Option[String] = None,
    bcpPacketSize: Option[Number] = None,
    useBcpFullLoad: Option[Boolean] = None
  ): software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty =
    (new software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty.Builder)
      .safeguardPolicy(safeguardPolicy.orNull)
      .secretsManagerAccessRoleArn(secretsManagerAccessRoleArn.orNull)
      .secretsManagerSecretId(secretsManagerSecretId.orNull)
      .readBackupOnly(readBackupOnly.map(Boolean.box).orNull)
      .querySingleAlwaysOnNode(querySingleAlwaysOnNode.map(Boolean.box).orNull)
      .useThirdPartyBackupDevice(useThirdPartyBackupDevice.map(Boolean.box).orNull)
      .controlTablesFileGroup(controlTablesFileGroup.orNull)
      .bcpPacketSize(bcpPacketSize.orNull)
      .useBcpFullLoad(useBcpFullLoad.map(Boolean.box).orNull)
      .build()
}
