package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomAttributeConfig {

  def apply(
    dataType: String,
    numberConstraints: Option[software.amazon.awscdk.services.cognito.NumberAttributeConstraints] = None,
    stringConstraints: Option[software.amazon.awscdk.services.cognito.StringAttributeConstraints] = None,
    mutable: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.CustomAttributeConfig =
    (new software.amazon.awscdk.services.cognito.CustomAttributeConfig.Builder)
      .dataType(dataType)
      .numberConstraints(numberConstraints.orNull)
      .stringConstraints(stringConstraints.orNull)
      .mutable(mutable.map(Boolean.box).orNull)
      .build()
}
