package io.burkard.cdk.services.codebuild

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BitBucketSourceProps {

  def apply(
    owner: String,
    repo: String,
    buildStatusName: Option[String] = None,
    reportBuildStatus: Option[Boolean] = None,
    identifier: Option[String] = None,
    webhookFilters: Option[List[_ <: software.amazon.awscdk.services.codebuild.FilterGroup]] = None,
    branchOrRef: Option[String] = None,
    buildStatusUrl: Option[String] = None,
    cloneDepth: Option[Number] = None,
    webhookTriggersBatchBuild: Option[Boolean] = None,
    webhook: Option[Boolean] = None,
    fetchSubmodules: Option[Boolean] = None
  ): software.amazon.awscdk.services.codebuild.BitBucketSourceProps =
    (new software.amazon.awscdk.services.codebuild.BitBucketSourceProps.Builder)
      .owner(owner)
      .repo(repo)
      .buildStatusName(buildStatusName.orNull)
      .reportBuildStatus(reportBuildStatus.map(Boolean.box).orNull)
      .identifier(identifier.orNull)
      .webhookFilters(webhookFilters.map(_.asJava).orNull)
      .branchOrRef(branchOrRef.orNull)
      .buildStatusUrl(buildStatusUrl.orNull)
      .cloneDepth(cloneDepth.orNull)
      .webhookTriggersBatchBuild(webhookTriggersBatchBuild.map(Boolean.box).orNull)
      .webhook(webhook.map(Boolean.box).orNull)
      .fetchSubmodules(fetchSubmodules.map(Boolean.box).orNull)
      .build()
}
