package io.burkard.cdk.services.cloudtrail.cfnEventDataStore

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AdvancedFieldSelectorProperty {

  def apply(
    field: String,
    startsWith: Option[List[String]] = None,
    endsWith: Option[List[String]] = None,
    notEndsWith: Option[List[String]] = None,
    notStartsWith: Option[List[String]] = None,
    equalTo: Option[List[String]] = None,
    notEquals: Option[List[String]] = None
  ): software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty =
    (new software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty.Builder)
      .field(field)
      .startsWith(startsWith.map(_.asJava).orNull)
      .endsWith(endsWith.map(_.asJava).orNull)
      .notEndsWith(notEndsWith.map(_.asJava).orNull)
      .notStartsWith(notStartsWith.map(_.asJava).orNull)
      .equalTo(equalTo.map(_.asJava).orNull)
      .notEquals(notEquals.map(_.asJava).orNull)
      .build()
}
