package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OriginBindConfig {

  def apply(
    originProperty: Option[software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty] = None,
    failoverConfig: Option[software.amazon.awscdk.services.cloudfront.OriginFailoverConfig] = None
  ): software.amazon.awscdk.services.cloudfront.OriginBindConfig =
    (new software.amazon.awscdk.services.cloudfront.OriginBindConfig.Builder)
      .originProperty(originProperty.orNull)
      .failoverConfig(failoverConfig.orNull)
      .build()
}
