package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestCountScalingProps {

  def apply(
    targetRequestsPerMinute: Option[Number] = None,
    disableScaleIn: Option[Boolean] = None,
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.autoscaling.RequestCountScalingProps =
    (new software.amazon.awscdk.services.autoscaling.RequestCountScalingProps.Builder)
      .targetRequestsPerMinute(targetRequestsPerMinute.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .cooldown(cooldown.orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .build()
}
