package io.burkard.cdk.services.auditmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAssessmentProps {

  def apply(
    name: Option[String] = None,
    description: Option[String] = None,
    scope: Option[software.amazon.awscdk.services.auditmanager.CfnAssessment.ScopeProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    frameworkId: Option[String] = None,
    assessmentReportsDestination: Option[software.amazon.awscdk.services.auditmanager.CfnAssessment.AssessmentReportsDestinationProperty] = None,
    roles: Option[List[_]] = None,
    status: Option[String] = None,
    awsAccount: Option[software.amazon.awscdk.services.auditmanager.CfnAssessment.AWSAccountProperty] = None
  ): software.amazon.awscdk.services.auditmanager.CfnAssessmentProps =
    (new software.amazon.awscdk.services.auditmanager.CfnAssessmentProps.Builder)
      .name(name.orNull)
      .description(description.orNull)
      .scope(scope.orNull)
      .tags(tags.map(_.asJava).orNull)
      .frameworkId(frameworkId.orNull)
      .assessmentReportsDestination(assessmentReportsDestination.orNull)
      .roles(roles.map(_.asJava).orNull)
      .status(status.orNull)
      .awsAccount(awsAccount.orNull)
      .build()
}
