package io.burkard.cdk.services.apprunner

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnObservabilityConfigurationProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    traceConfiguration: Option[software.amazon.awscdk.services.apprunner.CfnObservabilityConfiguration.TraceConfigurationProperty] = None,
    observabilityConfigurationName: Option[String] = None
  ): software.amazon.awscdk.services.apprunner.CfnObservabilityConfigurationProps =
    (new software.amazon.awscdk.services.apprunner.CfnObservabilityConfigurationProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .traceConfiguration(traceConfiguration.orNull)
      .observabilityConfigurationName(observabilityConfigurationName.orNull)
      .build()
}
