package io.burkard.cdk.services.appmesh.cfnVirtualGateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VirtualGatewayClientPolicyTlsProperty {

  def apply(
    validation: software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty,
    ports: Option[List[_ <: Number]] = None,
    certificate: Option[software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty] = None,
    enforce: Option[Boolean] = None
  ): software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty =
    (new software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Builder)
      .validation(validation)
      .ports(ports.map(_.asJava).orNull)
      .certificate(certificate.orNull)
      .enforce(enforce.map(Boolean.box).orNull)
      .build()
}
