package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TcpHealthCheckOptions {

  def apply(
    timeout: Option[software.amazon.awscdk.Duration] = None,
    interval: Option[software.amazon.awscdk.Duration] = None,
    healthyThreshold: Option[Number] = None,
    unhealthyThreshold: Option[Number] = None
  ): software.amazon.awscdk.services.appmesh.TcpHealthCheckOptions =
    (new software.amazon.awscdk.services.appmesh.TcpHealthCheckOptions.Builder)
      .timeout(timeout.orNull)
      .interval(interval.orNull)
      .healthyThreshold(healthyThreshold.orNull)
      .unhealthyThreshold(unhealthyThreshold.orNull)
      .build()
}
