package io.burkard.cdk.services.appmesh

sealed abstract class IpPreference(val underlying: software.amazon.awscdk.services.appmesh.IpPreference)
  extends Product
    with Serializable

object IpPreference {
  implicit def toAws(value: IpPreference): software.amazon.awscdk.services.appmesh.IpPreference =
    Option(value).map(_.underlying).orNull

  case object Ipv4Only
    extends IpPreference(software.amazon.awscdk.services.appmesh.IpPreference.IPV4_ONLY)

  case object Ipv4Preferred
    extends IpPreference(software.amazon.awscdk.services.appmesh.IpPreference.IPV4_PREFERRED)

  case object Ipv6Only
    extends IpPreference(software.amazon.awscdk.services.appmesh.IpPreference.IPV6_ONLY)

  case object Ipv6Preferred
    extends IpPreference(software.amazon.awscdk.services.appmesh.IpPreference.IPV6_PREFERRED)
}
