package io.burkard.cdk.services.appflow.cfnFlow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3OutputFormatConfigProperty {

  def apply(
    fileType: Option[String] = None,
    prefixConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.PrefixConfigProperty] = None,
    preserveSourceDataTyping: Option[Boolean] = None,
    aggregationConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.AggregationConfigProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.S3OutputFormatConfigProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.S3OutputFormatConfigProperty.Builder)
      .fileType(fileType.orNull)
      .prefixConfig(prefixConfig.orNull)
      .preserveSourceDataTyping(preserveSourceDataTyping.map(Boolean.box).orNull)
      .aggregationConfig(aggregationConfig.orNull)
      .build()
}
