package io.burkard.cdk.services.appflow.cfnFlow

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomConnectorDestinationPropertiesProperty {

  def apply(
    entityName: String,
    writeOperationType: Option[String] = None,
    idFieldNames: Option[List[String]] = None,
    customProperties: Option[AnyRef] = None,
    errorHandlingConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty.Builder)
      .entityName(entityName)
      .writeOperationType(writeOperationType.orNull)
      .idFieldNames(idFieldNames.map(_.asJava).orNull)
      .customProperties(customProperties.orNull)
      .errorHandlingConfig(errorHandlingConfig.orNull)
      .build()
}
