package io.burkard.cdk.services.appflow.cfnConnectorProfile

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomConnectorProfileCredentialsProperty {

  def apply(
    authenticationType: String,
    custom: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomAuthCredentialsProperty] = None,
    apiKey: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.ApiKeyCredentialsProperty] = None,
    basic: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.BasicAuthCredentialsProperty] = None,
    oauth2: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuth2CredentialsProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomConnectorProfileCredentialsProperty =
    (new software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomConnectorProfileCredentialsProperty.Builder)
      .authenticationType(authenticationType)
      .custom(custom.orNull)
      .apiKey(apiKey.orNull)
      .basic(basic.orNull)
      .oauth2(oauth2.orNull)
      .build()
}
