package io.burkard.cdk.services.amplify.cfnBranch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BasicAuthConfigProperty {

  def apply(
    password: String,
    username: String,
    enableBasicAuth: Option[Boolean] = None
  ): software.amazon.awscdk.services.amplify.CfnBranch.BasicAuthConfigProperty =
    (new software.amazon.awscdk.services.amplify.CfnBranch.BasicAuthConfigProperty.Builder)
      .password(password)
      .username(username)
      .enableBasicAuth(enableBasicAuth.map(Boolean.box).orNull)
      .build()
}
