package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TestOptions {

  def apply(
    diffAssets: Option[Boolean] = None,
    regions: Option[List[String]] = None,
    allowDestroy: Option[List[String]] = None,
    hooks: Option[software.amazon.awscdk.cloudassembly.schema.Hooks] = None,
    cdkCommandOptions: Option[software.amazon.awscdk.cloudassembly.schema.CdkCommands] = None,
    stackUpdateWorkflow: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.TestOptions =
    (new software.amazon.awscdk.cloudassembly.schema.TestOptions.Builder)
      .diffAssets(diffAssets.map(Boolean.box).orNull)
      .regions(regions.map(_.asJava).orNull)
      .allowDestroy(allowDestroy.map(_.asJava).orNull)
      .hooks(hooks.orNull)
      .cdkCommandOptions(cdkCommandOptions.orNull)
      .stackUpdateWorkflow(stackUpdateWorkflow.map(Boolean.box).orNull)
      .build()
}
