package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DeployCommand {

  def apply(
    args: Option[software.amazon.awscdk.cloudassembly.schema.DeployOptions] = None,
    enabled: Option[Boolean] = None,
    expectedMessage: Option[String] = None,
    expectError: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.DeployCommand =
    (new software.amazon.awscdk.cloudassembly.schema.DeployCommand.Builder)
      .args(args.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .expectedMessage(expectedMessage.orNull)
      .expectError(expectError.map(Boolean.box).orNull)
      .build()
}
