package io.burkard.cdk.cfnStackSet

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DeploymentTargetsProperty {

  def apply(
    accountFilterType: Option[String] = None,
    accounts: Option[List[String]] = None,
    organizationalUnitIds: Option[List[String]] = None
  ): software.amazon.awscdk.CfnStackSet.DeploymentTargetsProperty =
    (new software.amazon.awscdk.CfnStackSet.DeploymentTargetsProperty.Builder)
      .accountFilterType(accountFilterType.orNull)
      .accounts(accounts.map(_.asJava).orNull)
      .organizationalUnitIds(organizationalUnitIds.map(_.asJava).orNull)
      .build()
}
