package io.burkard.cdk.alexa.ask

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSkill {

  def apply(
    internalResourceId: String,
    authenticationConfiguration: software.amazon.awscdk.alexa.ask.CfnSkill.AuthenticationConfigurationProperty,
    vendorId: String,
    skillPackage: software.amazon.awscdk.alexa.ask.CfnSkill.SkillPackageProperty
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.alexa.ask.CfnSkill =
    software.amazon.awscdk.alexa.ask.CfnSkill.Builder
      .create(stackCtx, internalResourceId)
      .authenticationConfiguration(authenticationConfiguration)
      .vendorId(vendorId)
      .skillPackage(skillPackage)
      .build()
}
