package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SecretValue {

  def apply(
    protectedValue: AnyRef,
    stackTrace: Option[Boolean] = None
  ): software.amazon.awscdk.SecretValue =
    software.amazon.awscdk.SecretValue.Builder
      .create(protectedValue)
      .stackTrace(stackTrace.map(Boolean.box).orNull)
      .build()
}
