package io.burkard.cdk.services.timestream.cfnScheduledQuery

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TimestreamConfigurationProperty {

  def apply(
    timeColumn: String,
    tableName: String,
    databaseName: String,
    dimensionMappings: List[_],
    measureNameColumn: Option[String] = None,
    multiMeasureMappings: Option[software.amazon.awscdk.services.timestream.CfnScheduledQuery.MultiMeasureMappingsProperty] = None,
    mixedMeasureMappings: Option[List[_]] = None
  ): software.amazon.awscdk.services.timestream.CfnScheduledQuery.TimestreamConfigurationProperty =
    (new software.amazon.awscdk.services.timestream.CfnScheduledQuery.TimestreamConfigurationProperty.Builder)
      .timeColumn(timeColumn)
      .tableName(tableName)
      .databaseName(databaseName)
      .dimensionMappings(dimensionMappings.asJava)
      .measureNameColumn(measureNameColumn.orNull)
      .multiMeasureMappings(multiMeasureMappings.orNull)
      .mixedMeasureMappings(mixedMeasureMappings.map(_.asJava).orNull)
      .build()
}
