package io.burkard.cdk.services.servicecatalog

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TemplateRule {

  def apply(
    ruleName: String,
    assertions: List[_ <: software.amazon.awscdk.services.servicecatalog.TemplateRuleAssertion],
    condition: Option[software.amazon.awscdk.ICfnRuleConditionExpression] = None
  ): software.amazon.awscdk.services.servicecatalog.TemplateRule =
    (new software.amazon.awscdk.services.servicecatalog.TemplateRule.Builder)
      .ruleName(ruleName)
      .assertions(assertions.asJava)
      .condition(condition.orNull)
      .build()
}
