package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationProductVersion {

  def apply(
    cloudFormationTemplate: software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate,
    description: Option[String] = None,
    productVersionName: Option[String] = None,
    validateTemplate: Option[Boolean] = None
  ): software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion =
    (new software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion.Builder)
      .cloudFormationTemplate(cloudFormationTemplate)
      .description(description.orNull)
      .productVersionName(productVersionName.orNull)
      .validateTemplate(validateTemplate.map(Boolean.box).orNull)
      .build()
}
