package io.burkard.cdk.services.sam.cfnFunction

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApiEventProperty {

  def apply(
    method: String,
    path: String,
    requestParameters: Option[List[_]] = None,
    auth: Option[software.amazon.awscdk.services.sam.CfnFunction.AuthProperty] = None,
    requestModel: Option[software.amazon.awscdk.services.sam.CfnFunction.RequestModelProperty] = None,
    restApiId: Option[String] = None
  ): software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty =
    (new software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty.Builder)
      .method(method)
      .path(path)
      .requestParameters(requestParameters.map(_.asJava).orNull)
      .auth(auth.orNull)
      .requestModel(requestModel.orNull)
      .restApiId(restApiId.orNull)
      .build()
}
