package io.burkard.cdk.services.sagemaker.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RStudioServerProDomainSettingsProperty {

  def apply(
    domainExecutionRoleArn: String,
    defaultResourceSpec: Option[software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty] = None,
    rStudioConnectUrl: Option[String] = None,
    rStudioPackageManagerUrl: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty.Builder)
      .domainExecutionRoleArn(domainExecutionRoleArn)
      .defaultResourceSpec(defaultResourceSpec.orNull)
      .rStudioConnectUrl(rStudioConnectUrl.orNull)
      .rStudioPackageManagerUrl(rStudioPackageManagerUrl.orNull)
      .build()
}
