package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataQualityJobDefinitionProps {

  def apply(
    dataQualityAppSpecification: software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty,
    dataQualityJobInput: software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty,
    jobResources: software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty,
    dataQualityJobOutputConfig: software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty,
    roleArn: String,
    networkConfig: Option[software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dataQualityBaselineConfig: Option[software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty] = None,
    stoppingCondition: Option[software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty] = None,
    jobDefinitionName: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinitionProps =
    (new software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinitionProps.Builder)
      .dataQualityAppSpecification(dataQualityAppSpecification)
      .dataQualityJobInput(dataQualityJobInput)
      .jobResources(jobResources)
      .dataQualityJobOutputConfig(dataQualityJobOutputConfig)
      .roleArn(roleArn)
      .networkConfig(networkConfig.orNull)
      .tags(tags.map(_.asJava).orNull)
      .dataQualityBaselineConfig(dataQualityBaselineConfig.orNull)
      .stoppingCondition(stoppingCondition.orNull)
      .jobDefinitionName(jobDefinitionName.orNull)
      .build()
}
