package io.burkard.cdk.services.resiliencehub.cfnApp

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourceMappingProperty {

  def apply(
    mappingType: String,
    physicalResourceId: software.amazon.awscdk.services.resiliencehub.CfnApp.PhysicalResourceIdProperty,
    terraformSourceName: Option[String] = None,
    resourceName: Option[String] = None,
    logicalStackName: Option[String] = None
  ): software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty =
    (new software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty.Builder)
      .mappingType(mappingType)
      .physicalResourceId(physicalResourceId)
      .terraformSourceName(terraformSourceName.orNull)
      .resourceName(resourceName.orNull)
      .logicalStackName(logicalStackName.orNull)
      .build()
}
