package io.burkard.cdk.services.pinpoint

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCampaign {

  def apply(
    internalResourceId: String,
    name: String,
    applicationId: String,
    segmentId: String,
    schedule: software.amazon.awscdk.services.pinpoint.CfnCampaign.ScheduleProperty,
    holdoutPercent: Option[Number] = None,
    treatmentDescription: Option[String] = None,
    priority: Option[Number] = None,
    segmentVersion: Option[Number] = None,
    templateConfiguration: Option[software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateConfigurationProperty] = None,
    description: Option[String] = None,
    tags: Option[AnyRef] = None,
    treatmentName: Option[String] = None,
    messageConfiguration: Option[software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageConfigurationProperty] = None,
    additionalTreatments: Option[List[_]] = None,
    customDeliveryConfiguration: Option[software.amazon.awscdk.services.pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty] = None,
    campaignHook: Option[software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignHookProperty] = None,
    limits: Option[software.amazon.awscdk.services.pinpoint.CfnCampaign.LimitsProperty] = None,
    isPaused: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnCampaign =
    software.amazon.awscdk.services.pinpoint.CfnCampaign.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .applicationId(applicationId)
      .segmentId(segmentId)
      .schedule(schedule)
      .holdoutPercent(holdoutPercent.orNull)
      .treatmentDescription(treatmentDescription.orNull)
      .priority(priority.orNull)
      .segmentVersion(segmentVersion.orNull)
      .templateConfiguration(templateConfiguration.orNull)
      .description(description.orNull)
      .tags(tags.orNull)
      .treatmentName(treatmentName.orNull)
      .messageConfiguration(messageConfiguration.orNull)
      .additionalTreatments(additionalTreatments.map(_.asJava).orNull)
      .customDeliveryConfiguration(customDeliveryConfiguration.orNull)
      .campaignHook(campaignHook.orNull)
      .limits(limits.orNull)
      .isPaused(isPaused.map(Boolean.box).orNull)
      .build()
}
