package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSchema {

  def apply(
    internalResourceId: String,
    name: String,
    schema: String,
    domain: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.personalize.CfnSchema =
    software.amazon.awscdk.services.personalize.CfnSchema.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .schema(schema)
      .domain(domain.orNull)
      .build()
}
