package io.burkard.cdk.services.networkmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomerGatewayAssociationProps {

  def apply(
    globalNetworkId: String,
    deviceId: String,
    customerGatewayArn: String,
    linkId: Option[String] = None
  ): software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps =
    (new software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps.Builder)
      .globalNetworkId(globalNetworkId)
      .deviceId(deviceId)
      .customerGatewayArn(customerGatewayArn)
      .linkId(linkId.orNull)
      .build()
}
