package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConfigurationProps {

  def apply(
    name: String,
    serverProperties: String,
    description: Option[String] = None,
    kafkaVersionsList: Option[List[String]] = None
  ): software.amazon.awscdk.services.msk.CfnConfigurationProps =
    (new software.amazon.awscdk.services.msk.CfnConfigurationProps.Builder)
      .name(name)
      .serverProperties(serverProperties)
      .description(description.orNull)
      .kafkaVersionsList(kafkaVersionsList.map(_.asJava).orNull)
      .build()
}
