package io.burkard.cdk.services.mediatailor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPlaybackConfigurationProps {

  def apply(
    videoContentSourceUrl: String,
    name: String,
    adDecisionServerUrl: String,
    transcodeProfileName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    slateAdUrl: Option[String] = None,
    livePreRollConfiguration: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty] = None,
    configurationAliases: Option[Map[String, _]] = None,
    manifestProcessingRules: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty] = None,
    dashConfiguration: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty] = None,
    availSuppression: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty] = None,
    cdnConfiguration: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty] = None,
    bumper: Option[software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.BumperProperty] = None,
    personalizationThresholdSeconds: Option[Number] = None
  ): software.amazon.awscdk.services.mediatailor.CfnPlaybackConfigurationProps =
    (new software.amazon.awscdk.services.mediatailor.CfnPlaybackConfigurationProps.Builder)
      .videoContentSourceUrl(videoContentSourceUrl)
      .name(name)
      .adDecisionServerUrl(adDecisionServerUrl)
      .transcodeProfileName(transcodeProfileName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .slateAdUrl(slateAdUrl.orNull)
      .livePreRollConfiguration(livePreRollConfiguration.orNull)
      .configurationAliases(configurationAliases.map(_.asJava).orNull)
      .manifestProcessingRules(manifestProcessingRules.orNull)
      .dashConfiguration(dashConfiguration.orNull)
      .availSuppression(availSuppression.orNull)
      .cdnConfiguration(cdnConfiguration.orNull)
      .bumper(bumper.orNull)
      .personalizationThresholdSeconds(personalizationThresholdSeconds.orNull)
      .build()
}
