package io.burkard.cdk.services.managedblockchain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNodeProps {

  def apply(
    nodeConfiguration: software.amazon.awscdk.services.managedblockchain.CfnNode.NodeConfigurationProperty,
    networkId: String,
    memberId: Option[String] = None
  ): software.amazon.awscdk.services.managedblockchain.CfnNodeProps =
    (new software.amazon.awscdk.services.managedblockchain.CfnNodeProps.Builder)
      .nodeConfiguration(nodeConfiguration)
      .networkId(networkId)
      .memberId(memberId.orNull)
      .build()
}
