package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventInvokeConfig {

  def apply(
    internalResourceId: String,
    function: software.amazon.awscdk.services.lambda.IFunction,
    qualifier: Option[String] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    onSuccess: Option[software.amazon.awscdk.services.lambda.IDestination] = None,
    retryAttempts: Option[Number] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IDestination] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.EventInvokeConfig =
    software.amazon.awscdk.services.lambda.EventInvokeConfig.Builder
      .create(stackCtx, internalResourceId)
      .function(function)
      .qualifier(qualifier.orNull)
      .maxEventAge(maxEventAge.orNull)
      .onSuccess(onSuccess.orNull)
      .retryAttempts(retryAttempts.orNull)
      .onFailure(onFailure.orNull)
      .build()
}
