package io.burkard.cdk.services.lambda

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DockerImageFunction {

  def apply(
    internalResourceId: String,
    code: software.amazon.awscdk.services.lambda.DockerImageCode,
    ephemeralStorageSize: Option[software.amazon.awscdk.Size] = None,
    codeSigningConfig: Option[software.amazon.awscdk.services.lambda.ICodeSigningConfig] = None,
    logRetention: Option[software.amazon.awscdk.services.logs.RetentionDays] = None,
    initialPolicy: Option[List[_ <: software.amazon.awscdk.services.iam.PolicyStatement]] = None,
    deadLetterTopic: Option[software.amazon.awscdk.services.sns.ITopic] = None,
    layers: Option[List[_ <: software.amazon.awscdk.services.lambda.ILayerVersion]] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    functionName: Option[String] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    description: Option[String] = None,
    filesystem: Option[software.amazon.awscdk.services.lambda.FileSystem] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    environmentEncryption: Option[software.amazon.awscdk.services.kms.IKey] = None,
    profilingGroup: Option[software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup] = None,
    memorySize: Option[Number] = None,
    allowPublicSubnet: Option[Boolean] = None,
    architecture: Option[software.amazon.awscdk.services.lambda.Architecture] = None,
    profiling: Option[Boolean] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    onSuccess: Option[software.amazon.awscdk.services.lambda.IDestination] = None,
    insightsVersion: Option[software.amazon.awscdk.services.lambda.LambdaInsightsVersion] = None,
    allowAllOutbound: Option[Boolean] = None,
    reservedConcurrentExecutions: Option[Number] = None,
    currentVersionOptions: Option[software.amazon.awscdk.services.lambda.VersionOptions] = None,
    environment: Option[Map[String, String]] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    deadLetterQueueEnabled: Option[Boolean] = None,
    retryAttempts: Option[Number] = None,
    tracing: Option[software.amazon.awscdk.services.lambda.Tracing] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IDestination] = None,
    logRetentionRetryOptions: Option[software.amazon.awscdk.services.lambda.LogRetentionRetryOptions] = None,
    logRetentionRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    events: Option[List[_ <: software.amazon.awscdk.services.lambda.IEventSource]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.DockerImageFunction =
    software.amazon.awscdk.services.lambda.DockerImageFunction.Builder
      .create(stackCtx, internalResourceId)
      .code(code)
      .ephemeralStorageSize(ephemeralStorageSize.orNull)
      .codeSigningConfig(codeSigningConfig.orNull)
      .logRetention(logRetention.orNull)
      .initialPolicy(initialPolicy.map(_.asJava).orNull)
      .deadLetterTopic(deadLetterTopic.orNull)
      .layers(layers.map(_.asJava).orNull)
      .maxEventAge(maxEventAge.orNull)
      .functionName(functionName.orNull)
      .role(role.orNull)
      .description(description.orNull)
      .filesystem(filesystem.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .environmentEncryption(environmentEncryption.orNull)
      .profilingGroup(profilingGroup.orNull)
      .memorySize(memorySize.orNull)
      .allowPublicSubnet(allowPublicSubnet.map(Boolean.box).orNull)
      .architecture(architecture.orNull)
      .profiling(profiling.map(Boolean.box).orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .onSuccess(onSuccess.orNull)
      .insightsVersion(insightsVersion.orNull)
      .allowAllOutbound(allowAllOutbound.map(Boolean.box).orNull)
      .reservedConcurrentExecutions(reservedConcurrentExecutions.orNull)
      .currentVersionOptions(currentVersionOptions.orNull)
      .environment(environment.map(_.asJava).orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .vpc(vpc.orNull)
      .deadLetterQueueEnabled(deadLetterQueueEnabled.map(Boolean.box).orNull)
      .retryAttempts(retryAttempts.orNull)
      .tracing(tracing.orNull)
      .onFailure(onFailure.orNull)
      .logRetentionRetryOptions(logRetentionRetryOptions.orNull)
      .logRetentionRole(logRetentionRole.orNull)
      .timeout(timeout.orNull)
      .events(events.map(_.asJava).orNull)
      .build()
}
