package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUrlProps {

  def apply(
    authType: String,
    targetFunctionArn: String,
    cors: Option[software.amazon.awscdk.services.lambda.CfnUrl.CorsProperty] = None,
    qualifier: Option[String] = None
  ): software.amazon.awscdk.services.lambda.CfnUrlProps =
    (new software.amazon.awscdk.services.lambda.CfnUrlProps.Builder)
      .authType(authType)
      .targetFunctionArn(targetFunctionArn)
      .cors(cors.orNull)
      .qualifier(qualifier.orNull)
      .build()
}
