package io.burkard.cdk.services.kinesisanalytics.cfnApplication

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputProperty {

  def apply(
    inputSchema: software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty,
    namePrefix: String,
    kinesisFirehoseInput: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty] = None,
    inputParallelism: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty] = None,
    kinesisStreamsInput: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty] = None,
    inputProcessingConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty.Builder)
      .inputSchema(inputSchema)
      .namePrefix(namePrefix)
      .kinesisFirehoseInput(kinesisFirehoseInput.orNull)
      .inputParallelism(inputParallelism.orNull)
      .kinesisStreamsInput(kinesisStreamsInput.orNull)
      .inputProcessingConfiguration(inputProcessingConfiguration.orNull)
      .build()
}
