package io.burkard.cdk.services.iotwireless

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkAnalyzerConfiguration {

  def apply(
    internalResourceId: String,
    name: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    wirelessDevices: Option[List[String]] = None,
    traceContent: Option[AnyRef] = None,
    wirelessGateways: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iotwireless.CfnNetworkAnalyzerConfiguration =
    software.amazon.awscdk.services.iotwireless.CfnNetworkAnalyzerConfiguration.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .wirelessDevices(wirelessDevices.map(_.asJava).orNull)
      .traceContent(traceContent.orNull)
      .wirelessGateways(wirelessGateways.map(_.asJava).orNull)
      .build()
}
